import sys
input = sys.stdin.readline

n = int(input())
epsilon = float(input())
points = [tuple(map(float, input().split())) for _ in range(n)]

Q = list(range(n))

edges = []
for i in range(n):
    for j in range(i+1, n):
        xi, yi = points[i]
        xj, yj = points[j]
        w = abs(xi - xj) + abs(yi - yj)
        edges.append((w, i, j))

edges.sort()
parent = [i for i in range(n)]

def find(u):
    if parent[u] != u:
        parent[u] = find(parent[u])
    return parent[u]

mst_edges = []
for w, u, v in edges:
    ru, rv = find(u), find(v)
    if ru != rv:
        parent[ru] = rv
        mst_edges.append((u, v))
        if len(mst_edges) == n-1:
            break
print(len(Q))
print(' '.join(str(i+1) for i in Q))
for u, v in mst_edges:
    print(u+1, v+1)